<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');
require_auth(['admin', 'waiter', 'kitchen']);

$sql = "SELECT t.id, t.table_number, t.seats, t.status, t.merged_into_table_id, t.assigned_waiter_id,
               su.full_name AS assigned_waiter_name,
               o.id AS active_order_id,
               o.status AS active_order_status
        FROM tables t
        LEFT JOIN staff_users su ON su.id = t.assigned_waiter_id
        LEFT JOIN orders o ON o.table_id = t.id AND o.status IN ('received','preparing','ready','served')
        WHERE t.restaurant_id = :restaurant_id
        ORDER BY t.table_number ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute([':restaurant_id' => 1]);
$rows = $stmt->fetchAll();

foreach ($rows as &$row) {
    $row['id'] = (int) $row['id'];
    $row['seats'] = (int) $row['seats'];
    $row['merged_into_table_id'] = $row['merged_into_table_id'] !== null ? (int) $row['merged_into_table_id'] : null;
    $row['assigned_waiter_id'] = $row['assigned_waiter_id'] !== null ? (int) $row['assigned_waiter_id'] : null;
    $row['active_order_id'] = $row['active_order_id'] !== null ? (int) $row['active_order_id'] : null;
    $row['assigned_waiter_name'] = esc_html((string) ($row['assigned_waiter_name'] ?? ''));
}

json_success(['tables' => $rows]);