<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');
require_auth(['admin']);

$stmt = $pdo->prepare('SELECT id, full_name, username, role, is_active, created_at FROM staff_users WHERE restaurant_id = :restaurant_id ORDER BY role ASC, full_name ASC');
$stmt->execute([':restaurant_id' => 1]);
$rows = $stmt->fetchAll();
foreach ($rows as &$row) {
    $row['id'] = (int) $row['id'];
    $row['is_active'] = (bool) $row['is_active'];
    $row['full_name'] = esc_html((string) $row['full_name']);
    $row['username'] = esc_html((string) $row['username']);
}

json_success(['staff' => $rows]);