<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('POST');

$user = require_auth(['admin']);
$input = get_json_input();
$tableId = (int) ($input['table_id'] ?? 0);
$domain = clean_string($input['domain'] ?? '', 120);

if ($tableId <= 0 || $domain === '') {
    json_error('table_id and domain are required', 422);
}

if (!preg_match('/^https:\/\/[a-zA-Z0-9.-]+$/', $domain)) {
    json_error('Domain must be HTTPS and without path (e.g. https://yourdomain.com)', 422);
}

$tableStmt = $pdo->prepare('SELECT id, table_number FROM tables WHERE id = :table_id LIMIT 1');
$tableStmt->execute([':table_id' => $tableId]);
$table = $tableStmt->fetch();
if (!$table) {
    json_error('Table not found', 404);
}

$encodedUrl = $domain . '/menu.html?table=' . urlencode((string) $table['table_number']);
$qrEndpoint = 'https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=' . urlencode($encodedUrl);

$imageBinary = @file_get_contents($qrEndpoint);
if ($imageBinary === false) {
    json_error('Failed to generate QR image', 500);
}

$fileName = 'table_' . preg_replace('/[^a-zA-Z0-9]/', '_', (string) $table['table_number']) . '_' . time() . '.png';
$targetPathAbs = __DIR__ . '/../../public/assets/qr/' . $fileName;
$targetPathRel = 'assets/qr/' . $fileName;

if (file_put_contents($targetPathAbs, $imageBinary) === false) {
    json_error('Failed to save QR image', 500);
}

$ins = $pdo->prepare('INSERT INTO qr_codes (table_id, qr_data, image_path, generated_at, created_by_staff_id)
                      VALUES (:table_id, :qr_data, :image_path, NOW(), :created_by_staff_id)');
$ins->execute([
    ':table_id' => $tableId,
    ':qr_data' => $encodedUrl,
    ':image_path' => $targetPathRel,
    ':created_by_staff_id' => $user['id']
]);

json_success([
    'qr_code_id' => (int) $pdo->lastInsertId(),
    'table_number' => $table['table_number'],
    'url' => $encodedUrl,
    'image_path' => $targetPathRel
]);