<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('POST');

require_auth(['admin', 'kitchen', 'waiter']);
$input = get_json_input();

$orderId = (int) ($input['order_id'] ?? 0);
$orderItemId = (int) ($input['order_item_id'] ?? 0);
$status = clean_string($input['status'] ?? '', 20);
$allowed = ['received', 'preparing', 'ready', 'served'];

if (!in_array($status, $allowed, true)) {
    json_error('Invalid status', 422);
}

if ($orderItemId > 0) {
    $stmt = $pdo->prepare('UPDATE order_items SET status = :status WHERE id = :order_item_id');
    $stmt->execute([
        ':status' => $status,
        ':order_item_id' => $orderItemId
    ]);

    $refresh = $pdo->prepare('SELECT status FROM order_items WHERE order_id = :order_id');
    $refresh->execute([':order_id' => $orderId]);
    $statuses = $refresh->fetchAll();

    $aggregate = 'received';
    $allServed = true;
    $allReady = true;
    $hasPreparing = false;

    foreach ($statuses as $row) {
        if ($row['status'] !== 'served') {
            $allServed = false;
        }
        if (!in_array($row['status'], ['ready', 'served'], true)) {
            $allReady = false;
        }
        if ($row['status'] === 'preparing') {
            $hasPreparing = true;
        }
    }

    if ($allServed) {
        $aggregate = 'served';
    } elseif ($allReady) {
        $aggregate = 'ready';
    } elseif ($hasPreparing) {
        $aggregate = 'preparing';
    }

    $orderUpdate = $pdo->prepare('UPDATE orders SET status = :status WHERE id = :order_id');
    $orderUpdate->execute([
        ':status' => $aggregate,
        ':order_id' => $orderId
    ]);

    json_success(['message' => 'Item status updated', 'order_status' => $aggregate]);
}

if ($orderId <= 0) {
    json_error('order_id is required', 422);
}

$orderUpdate = $pdo->prepare('UPDATE orders SET status = :status WHERE id = :order_id');
$orderUpdate->execute([
    ':status' => $status,
    ':order_id' => $orderId
]);

$itemUpdate = $pdo->prepare('UPDATE order_items SET status = :status WHERE order_id = :order_id');
$itemUpdate->execute([
    ':status' => $status,
    ':order_id' => $orderId
]);

json_success(['message' => 'Order status updated']);