<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');
require_auth(['admin']);

$from = clean_string($_GET['from'] ?? '', 20);
$to = clean_string($_GET['to'] ?? '', 20);
$status = clean_string($_GET['status'] ?? '', 20);

$where = 'WHERE 1=1';
$params = [];

if ($from !== '') {
    $where .= ' AND DATE(o.created_at) >= :from_date';
    $params[':from_date'] = $from;
}
if ($to !== '') {
    $where .= ' AND DATE(o.created_at) <= :to_date';
    $params[':to_date'] = $to;
}
if ($status !== '') {
    $where .= ' AND o.status = :status';
    $params[':status'] = $status;
}

$sql = "SELECT o.id, o.status, o.created_at, o.updated_at, t.table_number,
            COALESCE(b.grand_total, 0) AS grand_total,
            COALESCE(b.is_paid, 0) AS is_paid
        FROM orders o
        INNER JOIN tables t ON t.id = o.table_id
        LEFT JOIN bills b ON b.order_id = o.id
        $where
        ORDER BY o.created_at DESC
        LIMIT 500";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

foreach ($rows as &$row) {
    $row['id'] = (int) $row['id'];
    $row['grand_total'] = (float) $row['grand_total'];
    $row['is_paid'] = (bool) $row['is_paid'];
    $row['table_number'] = esc_html((string) $row['table_number']);
}

json_success(['orders' => $rows]);