<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('POST');

$input = get_json_input();
$tableNumber = clean_string($input['table_number'] ?? '', 20);
if ($tableNumber === '') {
    json_error('Table number is required', 422);
}

$stmt = $pdo->prepare("UPDATE orders o
    INNER JOIN tables t ON t.id = o.table_id
    SET o.call_waiter_requested = 1
    WHERE t.table_number = :table_number AND o.status IN ('received','preparing','ready','served')");
$stmt->execute([':table_number' => $tableNumber]);

if ($stmt->rowCount() === 0) {
    json_error('No active order found for this table', 404);
}

json_success(['message' => 'Waiter has been notified']);