<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');

$tableNumber = clean_string($_GET['table_number'] ?? '', 20);
if ($tableNumber === '') {
    json_error('table_number is required', 422);
}

$sql = "SELECT o.id AS order_id, o.status AS order_status, o.created_at,
               oi.id AS order_item_id, oi.item_name_snapshot, oi.quantity, oi.status AS item_status, oi.special_notes
        FROM orders o
        INNER JOIN tables t ON t.id = o.table_id
        INNER JOIN order_items oi ON oi.order_id = o.id
        WHERE t.table_number = :table_number AND o.status IN ('received','preparing','ready','served')
        ORDER BY o.id DESC, oi.id ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute([':table_number' => $tableNumber]);
$rows = $stmt->fetchAll();

if (!$rows) {
    json_success(['order' => null]);
}

$order = [
    'order_id' => (int) $rows[0]['order_id'],
    'order_status' => $rows[0]['order_status'],
    'created_at' => $rows[0]['created_at'],
    'items' => []
];

foreach ($rows as $row) {
    $order['items'][] = [
        'order_item_id' => (int) $row['order_item_id'],
        'name' => esc_html((string) $row['item_name_snapshot']),
        'quantity' => (int) $row['quantity'],
        'status' => $row['item_status'],
        'special_notes' => esc_html((string) ($row['special_notes'] ?? ''))
    ];
}

json_success(['order' => $order]);