<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');

$user = current_user();
$params = [];
$where = "WHERE o.status IN ('received','preparing','ready','served')";

if ($user && $user['role'] === 'waiter') {
    $where .= ' AND t.assigned_waiter_id = :waiter_id';
    $params[':waiter_id'] = (int) $user['id'];
}

$sql = "SELECT
            o.id AS order_id,
            o.status AS order_status,
            o.special_notes AS order_notes,
            o.call_waiter_requested,
            o.created_at,
            TIMESTAMPDIFF(MINUTE, o.created_at, NOW()) AS minutes_elapsed,
            t.id AS table_id,
            t.table_number,
            oi.id AS order_item_id,
            oi.item_name_snapshot,
            oi.quantity,
            oi.special_notes AS item_notes,
            oi.status AS item_status
        FROM orders o
        INNER JOIN tables t ON t.id = o.table_id
        INNER JOIN order_items oi ON oi.order_id = o.id
        $where
        ORDER BY o.created_at ASC, oi.id ASC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

$orders = [];
foreach ($rows as $row) {
    $orderId = (int) $row['order_id'];
    if (!isset($orders[$orderId])) {
        $orders[$orderId] = [
            'order_id' => $orderId,
            'order_status' => $row['order_status'],
            'table_id' => (int) $row['table_id'],
            'table_number' => esc_html((string) $row['table_number']),
            'order_notes' => esc_html((string) ($row['order_notes'] ?? '')),
            'call_waiter_requested' => (bool) $row['call_waiter_requested'],
            'minutes_elapsed' => (int) $row['minutes_elapsed'],
            'items' => []
        ];
    }

    $orders[$orderId]['items'][] = [
        'order_item_id' => (int) $row['order_item_id'],
        'name' => esc_html((string) $row['item_name_snapshot']),
        'quantity' => (int) $row['quantity'],
        'notes' => esc_html((string) ($row['item_notes'] ?? '')),
        'status' => $row['item_status']
    ];
}

json_success(['orders' => array_values($orders)]);