<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('POST');
require_auth(['admin']);

$input = get_json_input();
$type = clean_string($input['type'] ?? '', 20);
$order = $input['order'] ?? [];

if (!in_array($type, ['categories', 'items'], true) || !is_array($order)) {
    json_error('Invalid reorder payload', 422);
}

$pdo->beginTransaction();
try {
    if ($type === 'categories') {
        $stmt = $pdo->prepare('UPDATE categories SET display_order = :display_order WHERE id = :id AND restaurant_id = :restaurant_id');
    } else {
        $stmt = $pdo->prepare('UPDATE menu_items SET display_order = :display_order WHERE id = :id AND restaurant_id = :restaurant_id');
    }

    foreach ($order as $idx => $id) {
        $stmt->execute([
            ':display_order' => $idx + 1,
            ':id' => (int) $id,
            ':restaurant_id' => 1
        ]);
    }

    $pdo->commit();
} catch (Throwable $e) {
    $pdo->rollBack();
    json_error('Reorder failed', 500);
}

json_success(['message' => 'Reordered']);