<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');

$restaurantId = 1;
$dayOfWeek = (int) date('w');
$currentTime = date('H:i:s');

$sql = 'SELECT
            c.id AS category_id,
            c.name AS category_name,
            c.display_order AS category_order,
            m.id AS item_id,
            m.name,
            m.description,
            m.image_path,
            m.price,
            m.tags,
            m.dietary_tags,
            m.availability_state,
            m.display_order
        FROM categories c
        LEFT JOIN menu_items m ON m.category_id = c.id AND m.is_active = 1
        WHERE c.restaurant_id = :restaurant_id
          AND c.is_active = 1
        ORDER BY c.display_order ASC, m.display_order ASC';

$stmt = $pdo->prepare($sql);
$stmt->execute([':restaurant_id' => $restaurantId]);
$rows = $stmt->fetchAll();

$grouped = [];
foreach ($rows as $row) {
    $catId = (int) $row['category_id'];
    if (!isset($grouped[$catId])) {
        $grouped[$catId] = [
            'id' => $catId,
            'name' => esc_html((string) $row['category_name']),
            'items' => []
        ];
    }

    if ($row['item_id'] === null) {
        continue;
    }

    $itemId = (int) $row['item_id'];
    $isTimeAllowed = true;

    $scheduleStmt = $pdo->prepare('SELECT id FROM item_availability_schedules WHERE menu_item_id = :menu_item_id AND day_of_week = :day AND :now BETWEEN start_time AND end_time LIMIT 1');
    $scheduleStmt->execute([
        ':menu_item_id' => $itemId,
        ':day' => $dayOfWeek,
        ':now' => $currentTime
    ]);

    $hasScheduleStmt = $pdo->prepare('SELECT COUNT(*) AS total FROM item_availability_schedules WHERE menu_item_id = :menu_item_id');
    $hasScheduleStmt->execute([':menu_item_id' => $itemId]);
    $hasSchedule = (int) $hasScheduleStmt->fetch()['total'] > 0;

    if ($hasSchedule && !$scheduleStmt->fetch()) {
        $isTimeAllowed = false;
    }

    $state = (string) $row['availability_state'];
    if ($state === 'out_of_stock') {
        $isTimeAllowed = false;
    }

    $grouped[$catId]['items'][] = [
        'id' => $itemId,
        'name' => esc_html((string) $row['name']),
        'description' => esc_html((string) ($row['description'] ?? '')),
        'image_path' => esc_html((string) ($row['image_path'] ?? '')),
        'price' => (float) $row['price'],
        'tags' => esc_html((string) ($row['tags'] ?? '')),
        'dietary_tags' => esc_html((string) ($row['dietary_tags'] ?? '')),
        'availability_state' => $state,
        'is_currently_available' => $isTimeAllowed
    ];
}

json_success([
    'categories' => array_values($grouped),
    'server_time' => date('Y-m-d H:i:s')
]);