<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    require_auth(['admin']);
    $stmt = $pdo->prepare('SELECT id, name, display_order, is_active FROM categories WHERE restaurant_id = :restaurant_id ORDER BY display_order ASC, id ASC');
    $stmt->execute([':restaurant_id' => 1]);
    $rows = $stmt->fetchAll();
    foreach ($rows as &$row) {
        $row['id'] = (int) $row['id'];
        $row['display_order'] = (int) $row['display_order'];
        $row['is_active'] = (bool) $row['is_active'];
        $row['name'] = esc_html((string) $row['name']);
    }
    json_success(['categories' => $rows]);
}

if ($method === 'POST') {
    require_auth(['admin']);
    $input = get_json_input();

    $action = clean_string($input['action'] ?? 'create', 20);

    if ($action === 'create') {
        $name = clean_string($input['name'] ?? '', 120);
        $displayOrder = (int) ($input['display_order'] ?? 0);
        if ($name === '') {
            json_error('Category name is required', 422);
        }

        $ins = $pdo->prepare('INSERT INTO categories (restaurant_id, name, display_order, is_active) VALUES (:restaurant_id, :name, :display_order, 1)');
        $ins->execute([
            ':restaurant_id' => 1,
            ':name' => $name,
            ':display_order' => $displayOrder
        ]);

        json_success(['category_id' => (int) $pdo->lastInsertId()]);
    }

    if ($action === 'update') {
        $id = (int) ($input['id'] ?? 0);
        $name = clean_string($input['name'] ?? '', 120);
        $displayOrder = (int) ($input['display_order'] ?? 0);
        $isActive = (int) (!empty($input['is_active']));

        if ($id <= 0 || $name === '') {
            json_error('Invalid category data', 422);
        }

        $upd = $pdo->prepare('UPDATE categories SET name = :name, display_order = :display_order, is_active = :is_active WHERE id = :id AND restaurant_id = :restaurant_id');
        $upd->execute([
            ':name' => $name,
            ':display_order' => $displayOrder,
            ':is_active' => $isActive,
            ':id' => $id,
            ':restaurant_id' => 1
        ]);

        json_success(['message' => 'Category updated']);
    }

    if ($action === 'delete') {
        $id = (int) ($input['id'] ?? 0);
        if ($id <= 0) {
            json_error('Invalid category ID', 422);
        }

        $del = $pdo->prepare('DELETE FROM categories WHERE id = :id AND restaurant_id = :restaurant_id');
        $del->execute([':id' => $id, ':restaurant_id' => 1]);

        json_success(['message' => 'Category deleted']);
    }
}

json_error('Method not allowed', 405);