<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('GET');
require_auth(['admin', 'waiter']);

$orderId = (int) ($_GET['order_id'] ?? 0);
if ($orderId <= 0) {
    json_error('order_id is required', 422);
}

$bill = recalculate_bill($pdo, $orderId);

$itemStmt = $pdo->prepare('SELECT item_name_snapshot, unit_price_snapshot, quantity, line_total FROM order_items WHERE order_id = :order_id ORDER BY id ASC');
$itemStmt->execute([':order_id' => $orderId]);
$items = $itemStmt->fetchAll();

$chargeStmt = $pdo->prepare('SELECT id, title, amount, created_at FROM manual_charges WHERE order_id = :order_id ORDER BY id DESC');
$chargeStmt->execute([':order_id' => $orderId]);
$charges = $chargeStmt->fetchAll();

$billStmt = $pdo->prepare('SELECT id, is_paid, split_count, closed_at FROM bills WHERE order_id = :order_id LIMIT 1');
$billStmt->execute([':order_id' => $orderId]);
$meta = $billStmt->fetch() ?: ['id' => null, 'is_paid' => 0, 'split_count' => 1, 'closed_at' => null];

json_success([
    'order_id' => $orderId,
    'bill_id' => $meta['id'] ? (int) $meta['id'] : null,
    'is_paid' => (bool) $meta['is_paid'],
    'split_count' => (int) $meta['split_count'],
    'closed_at' => $meta['closed_at'],
    'items' => $items,
    'manual_charges' => $charges,
    'totals' => $bill
]);