<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('POST');

$actor = require_auth(['admin']);
$input = get_json_input();

$fullName = clean_string($input['full_name'] ?? '', 120);
$username = clean_string($input['username'] ?? '', 60);
$password = (string) ($input['password'] ?? '');
$role = clean_string($input['role'] ?? '', 20);

if ($fullName === '' || $username === '' || $password === '' || !in_array($role, ['admin', 'waiter', 'kitchen'], true)) {
    json_error('Invalid staff payload', 422);
}

if (strlen($password) < 8) {
    json_error('Password must be at least 8 characters', 422);
}

$passwordHash = password_hash($password, PASSWORD_DEFAULT);
$insert = $pdo->prepare('INSERT INTO staff_users (restaurant_id, full_name, username, password_hash, role) VALUES (:restaurant_id, :full_name, :username, :password_hash, :role)');

try {
    $insert->execute([
        ':restaurant_id' => $actor['restaurant_id'],
        ':full_name' => $fullName,
        ':username' => $username,
        ':password_hash' => $passwordHash,
        ':role' => $role
    ]);
} catch (PDOException $e) {
    json_error('Username already exists', 409);
}

json_success(['staff_user_id' => (int) $pdo->lastInsertId()]);