<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('POST');

$token = $_SESSION['session_token'] ?? null;
if ($token) {
    $stmt = $pdo->prepare('DELETE FROM sessions WHERE session_token = :token');
    $stmt->execute([':token' => $token]);
}

$_SESSION = [];
if (ini_get('session.use_cookies')) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000, $params['path'], $params['domain'], $params['secure'], $params['httponly']);
}
session_destroy();

json_success(['message' => 'Logged out']);