<?php
declare(strict_types=1);

require_once __DIR__ . '/../common/bootstrap.php';
require_method('POST');

$input = get_json_input();
$username = clean_string($input['username'] ?? '', 60);
$password = (string) ($input['password'] ?? '');

if ($username === '' || $password === '') {
    json_error('Username and password are required', 422);
}

$stmt = $pdo->prepare('SELECT id, restaurant_id, full_name, username, password_hash, role, is_active FROM staff_users WHERE username = :username LIMIT 1');
$stmt->execute([':username' => $username]);
$user = $stmt->fetch();

if (!$user || (int) $user['is_active'] !== 1 || !password_verify($password, $user['password_hash'])) {
    json_error('Invalid credentials', 401);
}

session_regenerate_id(true);
$_SESSION['user'] = [
    'id' => (int) $user['id'],
    'restaurant_id' => (int) $user['restaurant_id'],
    'full_name' => $user['full_name'],
    'username' => $user['username'],
    'role' => $user['role']
];

$sessionToken = bin2hex(random_bytes(32));
$expiry = (new DateTimeImmutable('+12 hours'))->format('Y-m-d H:i:s');
$ip = clean_string($_SERVER['REMOTE_ADDR'] ?? '', 45);
$userAgent = clean_string($_SERVER['HTTP_USER_AGENT'] ?? '', 255);

$insertSession = $pdo->prepare('INSERT INTO sessions (staff_user_id, session_token, ip_address, user_agent, expires_at) VALUES (:staff_user_id, :session_token, :ip_address, :user_agent, :expires_at)');
$insertSession->execute([
    ':staff_user_id' => $user['id'],
    ':session_token' => $sessionToken,
    ':ip_address' => $ip,
    ':user_agent' => $userAgent,
    ':expires_at' => $expiry
]);

$_SESSION['session_token'] = $sessionToken;

json_success([
    'user' => [
        'id' => (int) $user['id'],
        'name' => $user['full_name'],
        'role' => $user['role'],
        'restaurant_id' => (int) $user['restaurant_id']
    ]
]);